<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CSocialMediaWidgetTwitter extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "4",
		"name"	=> "Twitter Feed",
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		global $base;

		External::Load("twitter");

		$tweet = new TweetPHP(array(
		  'consumer_key'              => $widget["settings"]["set_consumer_key"],
		  'consumer_secret'           => $widget["settings"]["set_consumer_secret"],
		  'access_token'              => $widget["settings"]["set_access_token"],
		  'access_token_secret'       => $widget["settings"]["set_access_secret"],
		  'twitter_screen_name'       => $widget["settings"]["set_screen_name"],
		  'cache_dir'				  => $_SERVER["DOCUMENT_ROOT"] . '/upload/tmp/', // Where on the server to save cached tweets

		));


		$tweets = $tweet->get_tweet_array();

		if (!is_array($tweets) || !is_array($tweets[0])) {
			return "";
		}


		$tweets = array_slice ( $tweets , 0 , $widget["settings"]["set_items"]);

		
		$elements = explode("," , $widget["settings"]["set_elements"]);

		foreach ($tweets as $key => $val) {

			$val["text"] = autolink($val["text"] , " class=\"link {BG:SCHEME} \"");
			$val["text"] = preg_replace("/#([A-Za-z0-9\/\.]*)/", "<a class=\"{BG:SCHEME} link\" target=\"_new\" href=\"http://twitter.com/search?q=$1\">#$1</a>", $val["text"]);

			$info = array(
				"user"	=> $val["user"]["screen_name"],
				"name"	=> $val["user"]["name"],
				"text"	=> $val["text"],
				"date"	=> CDate::toStr($widget["settings"]["set_date"] , strtotime($val["created_at"])),
				"avatar"	=> str_replace("_normal" , "_bigger" , $val["user"]["profile_image_url_https"]),
			);


			$items[] = array(
				"_avatar"	=> in_array("image" , $elements) ? $this->tpl->blockReplace("avatar" , $info) : "",
				"_text"		=> in_array("text" , $elements) ? $this->tpl->blockReplace("text" , $info) : "",
				"_user"		=> in_array("user" , $elements) ? $this->tpl->blockReplace("user" , $info) : "",
				"_name"		=> in_array("name" , $elements) ? $this->tpl->blockReplace("name" , $info) : "",
				"_date"		=> in_array("date" , $elements) ? $this->tpl->blockReplace("date" , $info) : "",
			);
		}


		if ($widget["settings"]["set_style"] == "1" ) {
			return $this->LargeWidget($widget , $items , $elements);
		} else {
			return $this->SmallWidget($widget , $items , $elements);
		}
	}

			
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LargeWidget($widget , $items , $elements) {
		global $base;
		

		return $this->tpl->blockReplace(
			"Widget" , 
			array(
				"data"	=> $base->html->table(
					$this->tpl , 
					"",	
					$items
				),
				"title"	=> $widget["widget_name"] ? $this->tpl->blockreplace("Title" , $widget ) : "",
				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),
				"class_2" => in_array("image" , $elements) ? "" : "no-avatar",
			),

			$widget ,
			$widget["settings"]
		);
		
	}
	

			
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SmallWidget($widget , $items  , $elements) {
		global $base;
		

		return $this->tpl->blockReplace(
			"SmallWidget" , 
			array(
				"data"	=> $base->html->table(
					$this->tpl , 
					"Small",	
					$items
				),
				"class_2" => in_array("image" , $elements) ? "" : "no-avatar",
				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "SmallCarousel" :"SmallList"),
			),
			$widget ,
			$widget["settings"]
		);
		
	}

}


?>